#!/usr/bin/env python3
#
# Fit pairs of straight tracks
# Details in Exercise 3 of Homework 8
#
# Much of the work is done in
# fit2DTracksConstrained.py
#
# CC 18 Feb 2019
#--------------------------
import numpy as np
import math
import ccHistStuff as cc
import matplotlib.pyplot as plt
import scipy.stats as stats 
from fit2DTracksConstrained import fit2DTracksConstrained 

# --------------------------------
# Here are the needed constants
#---------------------------------
nDetectors = 4
w          = 0.005  # 50 micron is strip width
s          = np.full(nDetectors, w/np.math.sqrt(12))  # resolution in each hit
xdet       = np.array([2., 3., 5., 7.]) # x coordinates of detectors
#---------------------------

# read all data into numpy arrays
data = np.loadtxt("straightTracks.txt")
xv   = data[:,0]   # true xverteces (called X0 in the exercise pdf)
yv   = data[:,1]   # true yverteces
nev  = len(xv)     # number of pairs of tracks
trk1 = data[:,[2,3,4,5]]   # hits for track number 1
trk2 = data[:,[6,7,8,9]]   # hits for track number 2

# Now do the constrained fit (reserve arrays)
fitVertex = np.empty(nev)  
pull      = np.empty(nev)
chiProb   = np.empty(nev)
x1 = xdet.copy()  # not sure if the copy is necessary, but it can't hurt
x2 = xdet.copy()
s1 = s.copy()
s2 = s.copy()
verbosity = 0
for i in range(nev):  # loop over pairs
    y1 = trk1[i][:]   # coordinates of trk 1 for this pair
    y2 = trk2[i][:]   # coordinates of trk 2 for this pair

    # guess parameters
    slope1 = ( y1[3] - y1[0] ) / ( x1[3] - x1[0] )
    slope2 = ( y2[3] - y2[0] ) / ( x2[3] - x2[0] )
    inter1 = y1[3] - slope1 * x1[3]
    inter2 = y2[3] - slope2 * x2[3]
    guess = np.array( [slope1, slope2, 0.5*(inter1+inter2)] )

    # fit now
    par, chisq, ndof, cov = fit2DTracksConstrained(x1, y1, s1, x2, y2, s2,
                                                   guess, nIter=10,
                                                   verbosity=verbosity)

    # The fitted vertex in microns and the pull 
    thisFitVertex = 10000*par[2]
    thisPull      = (par[2]-xv[i])/np.sqrt(cov[2][2])
    fitVertex[i]  = thisFitVertex
    pull[i]       = thisPull

    # chiprob is like TMath::Prob in ROOT.
    # Probability that an observed Chi-squared exceeds
    # the value chisq by chance, even for a correct model
    thisChiProb = 1. - stats.chi2.cdf(chisq, ndof)
    chiProb[i]  = thisChiProb
    
    # debug
    if verbosity > 0:
        print( "  " )
        print( "Pull:")
        print( (par[2]-xv[i])/np.sqrt(cov[2][2]))

# Plot the difference between the fitted and true vertex
fig3, ax3 = plt.subplots(1,1)
dxfit = fitVertex - 10000*xv
con3, bins3, _ = ax3.hist(dxfit, np.linspace(-500.,500.,101), histtype='step', color='black')
cc.statBox(ax3, dxfit, bins3)
ax3.set_xlim(bins3[0], bins3[-1])
ax3.set_xlabel("x(fit)-x0 (microns)")
fig3.show()
input("Press any key to continue")

# Plot the pull
fig4, ax4 = plt.subplots(1,1)
con4, bins4, _ = ax4.hist(pull, np.linspace(-4.,4.,40), histtype='step', color='black')
cc.statBox(ax4, pull, bins3)
ax4.set_xlim(bins4[0], bins4[-1])
ax4.set_xlabel("Pull of vertex fit")
fig4.show()
input("Press any key to continue")
    
# Plot the chisquared probability  (this is a bonus plot)
probFig, probAx = plt.subplots(1,1)
probContents, probBins, _ = probAx.hist(chiProb, np.linspace(0.,1.,25), histtype='step', color='black')
cc.statBox(probAx, chiProb, probBins)
probAx.set_xlim(probBins[0], probBins[-1])
probAx.set_xlabel("Probability of chisquared")
probFig.show()
input("Press <Enter> to continue") 

