#!/usr/bin/env python3
#
# Homework 7 Exercise 2
# Start from the solution to Homework 4 Exercise 1
# Add a fit to the first 25 bins.
# The fit uses fitAnExponential.py which does all the hard work
#
# CC  7 Feb 2019
#    18 Feb 2019   Added the fit
#--------------------------------------------------------------
import numpy as np
import matplotlib.pyplot as plt
import ccHistStuff as cc
from fitAnExponential import fitExp
import math

# read the data set
x = np.load("dataSet.npy")

# Plotting stuff (default: one subplot in x and one in y)
thisFigure, thisAxes = plt.subplots()

# the bin edges (nbins + 1 because of lower and upper edge)
nbins = 40
bins  = np.linspace(0, 20, nbins+1)

# the histogram
fig, ax = plt.subplots()
contents, binEdges, _ = ax.hist(x, bins, histtype='step', log=True, color='black')

# We were asked to add labels and stat box
ax.set_xlabel('X')
ax.set_ylabel('Entries per 0.5')
cc.statBox(ax, x, binEdges)

# This is purely esthetics (personal preference)
ax.tick_params("both", direction='in', length=10, right=True)
ax.set_xticks(binEdges, minor=True)
ax.tick_params("both", direction='in', length=7, right=True, which='minor')
ax.set_xlim(0, 20)

#----------------------------------------------------------
# Up to this point everything is like Homework 4 Exercise 1
# Now we do the fit
#----------------------------------------------------------
lastBinToFit = 25
guess = np.array( [contents[0], 1./x.mean()] )    # An initial guess 
par, chisq, ndof, cov = fitExp(contents, binEdges, guess, lastBin=lastBinToFit)
print("-----------------------------------")
print("par[0] = ", par[0], " +/-", math.sqrt(cov[0,0]))
print("par[1] = ", par[1], " +/-", math.sqrt(cov[1,1]))
print("chisq  = ", chisq)

# The fitted function
# Solid where we are fitting, then dashed
binCenters =  0.5 * (bins[1:] + bins[:-1])
fitFun     = par[0] * np.exp( -par[1]*binCenters )
ax.plot(binCenters[:lastBinToFit], fitFun[:lastBinToFit], linestyle='solid',  color='red')
ax.plot(binCenters[lastBinToFit-1:], fitFun[lastBinToFit-1:], linestyle='dashed', color='red')

fig.show()
input('Enter something to exit: ')
